(function () {
  'use strict';

  const STREAMS$1 = window?.streams || {};
  const config$1 = {
    timeRefresh: STREAMS$1.timeRefresh || 10000,
    programRefresh: STREAMS$1.programRefresh || 60000,
    swiperDelay: STREAMS$1.swiperDelay || 5000,
    apiUrl: STREAMS$1.api_url || '',
    baseUrl: STREAMS$1.base_url || '',
    idUser: STREAMS$1.id_user || 2,
    service: STREAMS$1.service || 'deezer',
    marqueeSpeed: STREAMS$1.marqueeSpeed || 12,
    marqueeGap: STREAMS$1.marqueeGap || '2rem',
    defaultCover: STREAMS$1.defaultCover || '/default-cover.png',
    animationLines: STREAMS$1.animationLines || 4
  };

  const toggleScheme = document.getElementById('toggle-scheme');
  const buttons = document.querySelectorAll('[data-outside]');
  const ACTIVE_CLASS = 'is-active';

  // Function to handle outside click for toggling classes
  // @param {HTMLElement} button - The button element that toggles the visibility of the target element
  // @returns {void}
  function outsideClick(button) {
    if (!button) return;
    const target = document.getElementById(button.dataset.outside);
    if (!target) return;
    function toggleClasses() {
      button.classList.toggle(ACTIVE_CLASS);
      target.classList.toggle(ACTIVE_CLASS);
      if (button.classList.contains(ACTIVE_CLASS)) {
        document.addEventListener('click', clickOutside);
        return;
      }
      document.removeEventListener('click', clickOutside);
    }
    button.addEventListener('click', toggleClasses);
    function clickOutside(event) {
      if (!target.contains(event.target) && !button.contains(event.target)) {
        toggleClasses();
        document.removeEventListener('click', clickOutside);
      }
    }
    const closeButton = target.querySelector('[data-close]');
    if (closeButton) {
      closeButton.addEventListener('click', () => {
        button.classList.remove(ACTIVE_CLASS);
        target.classList.remove(ACTIVE_CLASS);
        document.removeEventListener('click', clickOutside);
      });
    }
  }
  buttons.forEach(button => {
    outsideClick(button);
  });
  window.addEventListener('DOMContentLoaded', () => {
    const body = document.querySelector('body');
    body.classList.remove('preload');
  });
  if (toggleScheme) {
    toggleScheme.addEventListener('click', () => {
      const newTheme = document.documentElement.classList.contains('dark') ? 'light' : 'dark';
      if (newTheme === 'dark') {
        document.documentElement.classList.add('dark');
        document.documentElement.classList.remove('light');
      } else {
        document.documentElement.classList.remove('dark');
        document.documentElement.classList.add('light');
      }
      localStorage.setItem('theme', newTheme);
    });
  }

  // const headerBar = document.querySelector('.header')

  // window.addEventListener('scroll', function () {
  //   if (window.scrollY > 0) {
  //     headerBar.classList.add('header-fixed')
  //   } else {
  //     headerBar.classList.remove('header-fixed')
  //   }
  // })

  const sections = document.querySelectorAll('.section');
  sections.forEach(section => {
    const observer = new IntersectionObserver(entries => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          section.classList.add('is-visible');
          observer.unobserve(section);
        }
      });
    });
    observer.observe(section);
  });
  const container$4 = document.getElementById('playerAText');

  // Configuración
  const numeroDeLineas = config$1.animationLines;
  const contenidoBase = container$4.innerHTML.trim();
  const repeticiones = 20; // repite para efecto visual fluido

  container$4.innerHTML = ''; // Limpia el contenido original

  for (let i = 0; i < numeroDeLineas; i++) {
    const wrapper = document.createElement('div');
    wrapper.classList.add('marquee-line-wrapper');
    if (i % 2 !== 0) wrapper.classList.add('reverse');
    const inner = document.createElement('div');
    inner.classList.add('marquee-line');

    // Duplicamos contenido para que la animación sea continua
    let html = '';
    for (let j = 0; j < repeticiones; j++) {
      html += `${contenidoBase} `;
    }
    inner.innerHTML = html + html; // duplicado para loop perfecto

    wrapper.appendChild(inner);
    container$4.appendChild(wrapper);
  }
  const playerSection = document.getElementById('player-section');
  const player$1 = playerSection.querySelector('.player');
  function updatePlayerClass() {
    const rect = playerSection.getBoundingClientRect();
    if (rect.bottom <= 0) {
      player$1.classList.remove('is-static');
    } else {
      player$1.classList.add('is-static');
    }
  }
  window.addEventListener('scroll', () => {
    window.requestAnimationFrame(updatePlayerClass);
  }, {
    passive: true
  });
  updatePlayerClass();
  const menuItems = document.querySelectorAll('.header-menu-list a');
  let mobileMenuItems = [];
  function checkActiveMenuItem() {
    const scrollTop = window.scrollY;
    const windowHeight = window.innerHeight;
    const docHeight = document.documentElement.scrollHeight;
    let currentSection = '';
    const secondMenuItem = menuItems[1];
    const secondHref = secondMenuItem ? secondMenuItem.getAttribute('href') : null;
    const secondSection = secondHref && secondHref.startsWith('#') ? document.getElementById(secondHref.substring(1)) : null;
    const secondSectionTop = secondSection && isSectionVisible(secondSection) ? secondSection.offsetTop - 100 : Infinity;
    if (scrollTop < secondSectionTop) {
      currentSection = '';
    } else if (scrollTop + windowHeight >= docHeight - 10) {
      // Busca el último menú cuyo href apunte a una sección visible
      let lastVisibleMenuItem = null;
      for (let i = menuItems.length - 1; i >= 0; i--) {
        const href = menuItems[i].getAttribute('href');
        if (href && href.startsWith('#')) {
          const section = document.getElementById(href.substring(1));
          if (section && isSectionVisible(section)) {
            lastVisibleMenuItem = menuItems[i];
            break;
          }
        }
      }
      if (lastVisibleMenuItem) {
        const lastHref = lastVisibleMenuItem.getAttribute('href');
        currentSection = lastHref.substring(1);
      }
    } else {
      sections.forEach(section => {
        if (!isSectionVisible(section)) return;
        const sectionTop = section.offsetTop - 100;
        if (scrollTop >= sectionTop) {
          currentSection = section.getAttribute('id');
        }
      });
    }

    // Aplica a ambos menús
    const allItems = [...menuItems, ...mobileMenuItems];
    allItems.forEach(item => {
      item.classList.remove('is-active');
      const href = item.getAttribute('href');
      if (scrollTop < secondSectionTop && href === '#') {
        item.classList.add('is-active');
      } else if (href === `#${currentSection}`) {
        item.classList.add('is-active');
      }
    });
  }

  // Helper para verificar si la sección es visible
  function isSectionVisible(section) {
    if (!section) return false;
    const style = window.getComputedStyle(section);
    if (style.display === 'none' || style.visibility === 'hidden' || style.opacity === '0') return false;
    if (section.offsetHeight === 0) return false;
    return true;
  }
  checkActiveMenuItem();
  window.addEventListener('scroll', checkActiveMenuItem);
  const headerMenuList = document.querySelector('.header-menu-list');
  if (headerMenuList) {
    const mobileMenu = headerMenuList.cloneNode(true);
    mobileMenu.querySelectorAll('[data-mobile="false"]').forEach(el => el.remove());
    mobileMenu.className = 'mobile-menu-list';
    const mobileMenuContainer = document.getElementById('mobile-menu');
    if (mobileMenuContainer) {
      mobileMenuContainer.appendChild(mobileMenu);
      mobileMenuItems = mobileMenuContainer.querySelectorAll('a');
    }
  }
  const div = document.getElementById('player-fixed');
  function actualizarBottom() {
    const footer = document.getElementById('footer');
    const mobileMenu = document.getElementById('mobile-menu');
    const footerHeight = footer ? footer.offsetHeight : 0;
    const mobileMenuHeight = mobileMenu ? mobileMenu.offsetHeight : 0;
    const scrollTop = window.scrollY;
    const windowHeight = window.innerHeight;
    const docHeight = document.documentElement.scrollHeight;
    const distanciaAlFinal = docHeight - (scrollTop + windowHeight);
    const extraBottom = Math.max(0, footerHeight - distanciaAlFinal);

    // Cuando la pantalla sea inferior a 992px, sumar la altura del menú móvil
    if (window.innerWidth <= 992) {
      div.style.bottom = `${extraBottom + mobileMenuHeight}px`;
      return;
    }
    div.style.bottom = `${extraBottom}px`;
  }
  window.addEventListener('scroll', actualizarBottom);
  window.addEventListener('resize', actualizarBottom);
  actualizarBottom();

  // Obtener los datos de la búsqueda
  // @param {string} query - Consulta de búsqueda
  // @param {string} service - Servicio de búsqueda
  // @returns {Promise<object>} - Datos de la búsqueda
  const cache$1 = {};
  const getDataFromSearchApi = async (query, service) => {
    if (cache$1[query]) {
      return cache$1[query];
    }
    const streamUrl = `./api/search.php?query=${encodeURIComponent(query)}&service=${service}`;
    const response = await fetch(streamUrl);
    const data = await response.json();

    // Si no responde
    if (!data.results) {
      return {};
    }
    const results = data.results;
    cache$1[query] = results;
    return results;
  };

  // Obtener datos del stream
  // @param {string} streamUrl - URL del stream
  // @returns {Promise<object>} - Datos del stream
  async function getStreamData(streamUrl) {
    if (!streamUrl) {
      return {};
    }
    const jsonUri = `./api/met.php?url=${encodeURIComponent(streamUrl)}`;
    try {
      const response = await fetch(jsonUri);
      return response.json();
    } catch (error) {
      console.error('Error al obtener los datos del stream:', error);
      return {};
    }
  }

  const createSvgIcon = (path, viewBox = '0 0 24 24', clase = 'icon-general') => `<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="${viewBox}" class="${clase}">${path}</svg>`;
  const svgIcons = {
    appStore: createSvgIcon('<path fill="#fff" d="M207.8 0H12.2C5.4 0 0 5.5 0 12.2v49.6C0 68.5 5.4 74 12.2 74h195.6c6.7 0 12.2-5.5 12.2-12.2V12.2C220 5.5 214.6 0 207.8 0zm10.6 61.8c0 5.8-4.7 10.6-10.6 10.6H12.2c-5.9 0-10.6-4.8-10.6-10.6V12.2c0-5.8 4.7-10.6 10.6-10.6h195.6c5.9 0 10.6 4.8 10.6 10.6v49.6zM74.7 21.6v-1a4.9 4.9 0 0 0-5.2-4.4h-4v11h4c3.3 0 5.2-2 5.2-5.6zm-7.4 4v-7.9H70c1.9.3 3.2 2 3 4v.7c-.1 1.9-1.8 3.3-3.6 3.2h-2.1zM46 36.8c0-3.3 1.7-6.3 4.5-8a9.7 9.7 0 0 0-7.7-4.1c-3.2-.4-6.3 1.9-8 1.9-1.6 0-4.1-2-6.8-1.9-3.6.2-6.8 2.2-8.6 5.3-3.7 6.4-1 16 2.6 21.1 1.8 2.6 3.9 5.4 6.6 5.3 2.6 0 3.6-1.7 6.8-1.7 3.2 0 4.1 1.7 6.9 1.7 2.8 0 4.6-2.6 6.3-5.2 1.3-1.8 2.3-3.8 3-6a9.2 9.2 0 0 1-5.6-8.4zm-5.3-15.6a9.4 9.4 0 0 0 2.2-6.7 9.5 9.5 0 0 0-6.2 3.2 9 9 0 0 0-2.2 6.5c2.5 0 4.7-1 6.2-3zm30.8 12.2-8.2 23H67l2-6.2h8.8l2 6.2h3.8l-8.2-23h-3.9zm-1.5 14 3.4-10.1 3.5 10h-7zm119-20c1.6.1 3.1-.9 3.6-2.5H191a2 2 0 0 1-2 1h-.1a2.2 2.2 0 0 1-2-2.3v-.1h5.8v-.6c0-2.6-1.4-4.2-3.7-4.2h-.5c-2.1.3-3.6 2.3-3.3 4.4v.6c0 2 1.7 3.7 3.8 3.7zm0-7.3h.2c1 0 2 1 1.8 2.2H187c0-1.3 1-2.2 2.1-2.2zM170.3 25c0 1.6.7 2.2 2.5 2.2h1v-1.4h-.7c-.8 0-1.2-.4-1.2-1.2v-4.3h1.8v-1.4H172v-2.1h-1.6v2.1H169v1.4h1.3V25zm-35.7 2.3c1 0 2-.5 2.6-1.4h.1v1.3h1.6V15.6h-1.6v4.6h-.1c-.5-1-1.5-1.5-2.6-1.5-2 0-3.4 1.7-3.4 4.3 0 2.7 1.3 4.3 3.4 4.3zm.5-7.1c1.3 0 2.2 1 2.2 2.8 0 1.8-.9 2.9-2.2 2.9-1.4 0-2.2-1.1-2.2-2.9 0-1.7.8-2.8 2.2-2.8zm58.7 19.3c-4.7 0-7.7 3.4-7.7 8.6 0 5.3 3 8.5 7.8 8.5 3.8 0 6.7-2 7.2-5.1H198a3.8 3.8 0 0 1-3.9 2.4h-.5a4.4 4.4 0 0 1-4-4.8V49h11.8v-1.2c0-5-3-8.2-7.5-8.2zm4 7h-8.3a4.2 4.2 0 0 1 4.6-4.2 4 4 0 0 1 3.8 4.2zm-17.6-4h-.1v-2.8h-3.3v16.7h3.4V46c.1-2 1.7-3.4 3.6-3.4.5 0 1 0 1.5.2v-3.2l-1.1-.1a4 4 0 0 0-4 3zm-70-26.9h-1.6v11.6h1.7V15.6zm56 23.9c-4.9 0-8 3.3-8 8.5 0 5.3 3 8.6 8 8.6 4.8 0 7.8-3.3 7.8-8.6 0-5.2-3-8.5-7.9-8.5zm4.3 8.5c0 3.7-1.6 5.8-4.4 5.8s-4.4-2.1-4.4-5.8c0-3.6 1.7-5.7 4.4-5.7s4.4 2.1 4.4 5.7zm-11.2-27.8c1.2 0 1.8.7 1.8 2v5h1.6v-6a2.7 2.7 0 0 0-2.9-2.5c-1 0-2 .5-2.4 1.5h-.2v-1.3h-1.5v8.3h1.6V22c0-1 1-1.8 2-1.8zm-30.3 7v-5.7c0-1.8-1.1-2.8-3.2-2.8-2 0-3.2 1-3.4 2.4h1.6c.2-.6.8-1 1.7-1 1.1 0 1.7.5 1.7 1.4v.7l-2.2.1c-2 .2-3.1 1-3.1 2.5v.3a2.5 2.5 0 0 0 2.7 2.2c1 0 2-.4 2.5-1.3h.2v1.2h1.5zm-1.6-3a2 2 0 0 1-2.2 1.8c-.8 0-1.5-.5-1.5-1.2 0-.8.5-1.2 1.7-1.2l2-.2v.7zm-7-2a4 4 0 1 0-7.9.8v.8a4 4 0 0 0 4.3 3.5 4 4 0 0 0 3.6-4.3v-.7zm-4 3.7c-1.4 0-2.2-1-2.2-2.9 0-1.8.8-2.8 2.3-2.8 1.4 0 2.2 1 2.2 2.8 0 1.8-.8 2.9-2.3 2.9zm22.8 17.5-2.5-.6c-3-.7-4.2-1.7-4.2-3.3 0-2 2-3.4 4.7-3.4s4.6 1.3 4.8 3.6h3.5c-.1-4-3.4-6.6-8.3-6.6-4.8 0-8.3 2.7-8.3 6.7 0 3.2 2 5.1 6.2 6.1l3 .8c2.9.7 4.1 1.8 4.1 3.5 0 2-2 3.6-5 3.6s-5.1-1.5-5.4-3.8h-3.5c.2 4.2 3.7 6.8 8.7 6.8 5.4 0 8.8-2.7 8.8-7 0-3.3-1.9-5.2-6.6-6.4zm14-7.7h-3.4v4h-2.4v2.7h2.4V52c0 3.2 1.3 4.5 4.7 4.5.6 0 1.2 0 1.9-.2v-2.7l-1.1.1c-1.4 0-2-.7-2-2v-9.3h3.1v-2.7h-3.2v-4zm-40.5 3.8a6 6 0 0 0-5.3 3v-2.8H104V62h3.5v-8.3c1 1.9 3.1 3 5.3 2.9 4.2 0 7-3.4 7-8.6 0-5.1-2.9-8.5-7-8.5zm-.9 14.2c-2.6 0-4.4-2.3-4.4-5.7 0-3.3 1.8-5.6 4.4-5.6 2.7 0 4.4 2.3 4.4 5.7 0 3.4-1.7 5.6-4.4 5.6zM89.6 27.2l1.7-6.1h.1l1.7 6h1.7l2.3-8.2h-1.7L94 25.2h-.2L92.1 19h-1.5l-1.7 6.3h-.2L87.3 19h-1.7l2.3 8.3h1.7zm-5.2-5a4 4 0 1 0-7.8.8v.8a4 4 0 0 0 4.3 3.5 4 4 0 0 0 3.5-4.3v-.7zM80.5 26c-1.4 0-2.2-1-2.2-2.9 0-1.8.8-2.8 2.2-2.8 1.5 0 2.3 1 2.3 2.8 0 1.8-.8 2.9-2.3 2.9zm97-3.6V22c.2-1 1.1-1.9 2.2-1.8 1.1 0 1.7.7 1.7 2v5h1.7v-5.9c0-1.5-1.4-2.7-2.9-2.6-1 0-2 .5-2.5 1.5h-.1v-4.6H176v11.6h1.6v-4.9zM94.5 39.5a6 6 0 0 0-5.3 3v-2.8h-3.4V62h3.5v-8.3c1 1.9 3.1 3 5.3 2.9 4.1 0 7-3.4 7-8.6 0-5.1-2.9-8.5-7.1-8.5zm3.5 8.5c0 3.5-1.7 5.7-4.4 5.7-2.6 0-4.4-2.3-4.4-5.7 0-3.3 1.8-5.6 4.4-5.6 2.7 0 4.4 2.3 4.4 5.6zm6.5-20.8h1.6v-6a2.7 2.7 0 0 0-2.8-2.5c-1 0-2 .5-2.5 1.5h-.1v-1.3H99v8.3h1.6V22c0-1 1-1.8 2-1.8 1.2 0 1.8.7 1.8 2v5zm45.5.1a4 4 0 0 0 3.6-4.3v-.7a4 4 0 1 0-7.8.7v.8a4 4 0 0 0 4.3 3.5zm-2.6-4.3c0-1.8.8-2.8 2.3-2.8 1.4 0 2.2 1 2.2 2.8 0 1.8-.8 2.9-2.2 2.9-1.4 0-2.3-1-2.3-2.9z"/>', '0 0 220 74'),
    googlePlay: createSvgIcon('<path fill="#fff" d="M237.8 0H12.2C5.5 0 0 5.5 0 12.2v49.6C0 68.5 5.5 74 12.3 74h225.5c6.7 0 12.2-5.5 12.2-12.2V12.2C250 5.5 244.5 0 237.7 0zm10.6 61.8c0 5.8-4.8 10.6-10.7 10.6H12.3c-6 0-10.7-4.8-10.7-10.6V12.2c0-5.8 4.8-10.6 10.7-10.6h225.5c5.8 0 10.6 4.8 10.6 10.6v49.6zM102.6 24v-9.7h3v-1.7h-8v1.7h3.2V24h1.8zm29.6.2c1.6 0 3-.5 4.1-1.7a5.8 5.8 0 0 0 1.7-4.2 5.8 5.8 0 0 0-5.8-6c-1.7 0-3.1.6-4.2 1.7-1.2 1.2-1.7 2.6-1.7 4.3a5.8 5.8 0 0 0 5.9 6zm-3-9a4 4 0 0 1 3-1.2 4 4 0 0 1 2.8 1.2c.8.8 1.2 1.8 1.2 3 0 1.3-.4 2.3-1.2 3.1a4 4 0 0 1-2.8 1.2 4 4 0 0 1-3-1.2 4.2 4.2 0 0 1-1.1-3c0-1.3.4-2.3 1.2-3zM88.5 42.8V46h8a7 7 0 0 1-1.9 4.2 8.2 8.2 0 0 1-6.1 2.4c-5 0-8.8-4-8.8-8.8s3.9-8.9 8.8-8.9c2.6 0 4.6 1 6 2.4l2.3-2.4c-2-1.9-4.6-3.3-8.3-3.3C81.7 31.7 76 37 76 43.9 76 50.6 81.7 56 88.4 56c3.6 0 6.3-1.2 8.5-3.5a11 11 0 0 0 2.9-7.8c0-.7 0-1.5-.2-2H88.4zm-6-18.6c1.8 0 3.2-.5 4.2-1.7 1-1 1.5-2.2 1.5-3.8l-.1-.9v-.1h-5.7v1.7h4c-.1.8-.4 1.5-.9 2a4 4 0 0 1-3 1.1 4 4 0 0 1-4-4.2 4 4 0 0 1 4-4.3c1.3 0 2.3.4 3 1.3v.1l1.3-1.2-.1-.1c-.4-.6-1-1-1.8-1.3-.7-.4-1.5-.5-2.3-.5-1.7 0-3.1.6-4.2 1.7a5.8 5.8 0 0 0-1.8 4.3c0 1.6.6 3 1.8 4.2a5.6 5.6 0 0 0 4.2 1.7zm30.2-11.6h-1.8V24h1.8V12.6zm-16 9.7h-5V19H96v-1.7h-4.6v-3.1h5v-1.7h-6.8V24h6.9v-1.7zm44.8-5.4v-1.5l5.3 8.5h1.9V12.7h-1.8v8.2l-5.1-8.2h-2V24h1.7v-7zM119 24v-9.6h3v-1.7H114v1.7h3.1V24h1.8zm-10 16.5a7.7 7.7 0 0 0-8 7.8c0 4.5 3.6 7.9 8 7.9 4.3 0 7.8-3.4 7.8-7.9s-3.5-7.8-7.9-7.8zm0 12.6c-2.4 0-4.5-2-4.5-4.8s2-4.8 4.4-4.8c2.4 0 4.5 2 4.5 4.8s-2 4.8-4.5 4.8zm79.4-20.5H180v23h3.5v-8.7h4.8c3.8 0 7.5-2.7 7.5-7.1 0-4.4-3.7-7.2-7.5-7.2zm0 11.1h-4.9v-7.9h5a4 4 0 0 1 4 4 4 4 0 0 1-4 4zm-16.2 1.8c-.7-1.8-2.7-5-6.7-5s-7.4 3.1-7.4 7.8c0 4.4 3.3 7.8 7.8 7.8 3.6 0 5.6-2.1 6.5-3.4l-2.7-1.8a4.5 4.5 0 0 1-3.8 2.2 4 4 0 0 1-3.9-2.4l10.6-4.4-.4-.9zM161.4 48c-.1-3 2.3-4.6 4-4.6 1.5 0 2.6.7 3 1.7l-7 2.9zm63.4 2.8-4.2-10H217l6.2 14-3.5 7.8h3.6l9.4-21.8h-3.8l-4 10zm-15.1-10.5c-2.5 0-5.1 1.1-6.2 3.5l3 1.3c.7-1.3 2-1.7 3.2-1.7 1.8 0 3.6 1.1 3.7 3v.2c-.7-.3-2-.8-3.7-.8-3.2 0-6.6 1.8-6.6 5.1 0 3.1 2.7 5.1 5.7 5.1 2.3 0 3.6-1 4.4-2.2h.1v1.7h3.4v-8.8c0-4.1-3-6.4-7-6.4zm-.5 12.7c-1 0-2.7-.6-2.7-2 0-1.8 2-2.5 3.7-2.5 1.5 0 2.2.4 3.1.8a4.2 4.2 0 0 1-4 3.7zm-56.4 2.6h3.5v-23h-3.5v23zm45 0h3.4v-23h-3.5v23zM126 40.4a7.7 7.7 0 0 0-8 7.8c0 4.5 3.6 7.9 8 7.9 4.3 0 7.9-3.4 7.9-7.9s-3.6-7.8-8-7.8zm0 12.6c-2.4 0-4.5-2-4.5-4.8s2-4.8 4.5-4.8c2.3 0 4.4 2 4.4 4.8s-2 4.8-4.4 4.8zM147 42c-.8-1-2.3-1.7-4.2-1.7-4 0-7.5 3.4-7.5 7.8s3.6 7.9 7.5 7.9c1.9 0 3.4-.9 4.2-1.8v1.1c0 3-1.5 4.6-4.1 4.6-2.1 0-3.4-1.5-4-2.8l-3 1.3c.9 2 3.2 4.6 7 4.6 4 0 7.4-2.4 7.4-8.2V41h-3.2V42zM143.3 53c-2.4 0-4.4-2-4.4-4.8 0-2.7 2-4.8 4.4-4.8 2.4 0 4.2 2 4.2 4.8s-1.8 4.8-4.2 4.8zM19 14.6c-.3.5-.4 1.2-.4 2v40.8c0 .8.1 1.4.4 2L41.3 37 18.9 14.6zm30.6 14.2-26.3-15c-1.3-.7-2.4-.8-3.2-.3l22.4 22.4 7.1-7.1zM20 60.5c.8.4 2 .4 3.2-.3l26.3-15-7-7L20 60.4zm39.3-26.2L51 29.6 43.5 37l7.5 7.4 8.3-4.7c2.6-1.5 2.6-3.9 0-5.4z"/>', '0 0 250 74'),
    play: createSvgIcon('<path d="M6 4v16a1 1 0 0 0 1.524.852l13-8a1 1 0 0 0 0-1.704l-13-8A1 1 0 0 0 6 4z"/>'),
    playAlt: createSvgIcon('<path d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10-4.477 10-10 10Zm0-2a8 8 0 1 0 0-16 8 8 0 0 0 0 16ZM10.622 8.415l4.879 3.252a.4.4 0 0 1 0 .666l-4.88 3.252a.4.4 0 0 1-.621-.332V8.747a.4.4 0 0 1 .622-.332Z"/>'),
    stop: createSvgIcon('<path d="M17 4H7a3 3 0 0 0-3 3v10a3 3 0 0 0 3 3h10a3 3 0 0 0 3-3V7a3 3 0 0 0-3-3z"/>'),
    pause: createSvgIcon('<path d="M6 3H8V21H6V3ZM16 3H18V21H16V3Z"/>'),
    volumeOff: createSvgIcon('<path d="M10 7.2 6.6 10H3v4h3.6l3.4 2.8V7.2ZM5.9 16H2a1 1 0 0 1-1-1V9c0-.6.4-1 1-1h3.9l5.3-4.3a.5.5 0 0 1 .8.4v15.8a.5.5 0 0 1-.8.4L5.9 16Zm14.5-4 3.5 3.5-1.4 1.4-3.5-3.5-3.5 3.5-1.4-1.4 3.5-3.5L14 8.5 15.5 7l3.5 3.5L22.5 7 24 8.5 20.4 12Z"/>'),
    volumeLow: createSvgIcon('<path d="M13 7.2 9.6 10H6v4h3.6l3.4 2.8V7.2ZM8.9 16H5a1 1 0 0 1-1-1V9c0-.6.4-1 1-1h3.9l5.3-4.3a.5.5 0 0 1 .8.4v15.8a.5.5 0 0 1-.8.4L8.9 16Zm10 .6-1.5-1.4a4 4 0 0 0-.3-6.6l1.5-1.4a6 6 0 0 1 .3 9.4Z"/>'),
    volumeHigh: createSvgIcon('<path d="M15.7 16.7a6 6 0 010 0l-1.4-1.4a4 4 0 000-6.6l1.4-1.4a6 6 0 010 9.4Zm3.6 3.6a11 11 0 000-16.6L17.8 5.2a9 9 0 010 13.6l1.5 1.5a11 11 0 000 0ZM2 16q-1 0-1-.9V9Q1 8 2 8H5.9l5.3-4.3a.5.5 0 01.8.4V19.9a.5.5 0 01-.8.4L5.9 16H2Zm4.6-6H3v4H6.6L10 16.8V7.2L6.6 10Z"/>'),
    facebook: createSvgIcon('<path d="M17 14h-3v8h-4v-8H7v-4h3V7a5 5 0 0 1 5-5h3v4h-3q-1 0-1 1v3h4Z"></path>', '0 0 24 24', 'i i-facebook'),
    x: createSvgIcon('<path d="m17.7 3-5 5.8L8.4 3H2l7.5 9.7L2.5 21h3l5.5-6.2 4.8 6.2h6l-7.7-10.3 6.6-7.5h-3Zm-1 16.1L5.6 4.8h1.8L18.3 19h-1.7Z"/>'),
    whatsapp: createSvgIcon('<path d="m7.3 18.5.7.4A8 8 0 1 0 5 16l.4.7-.6 2.4 2.4-.6ZM2 22l1.4-5A10 10 0 1 1 7 20.6L2 22ZM8.4 7.3H9a85 85 0 0 1 1.3 2.3c0 .2 0 .4-.2.5a4.4 4.4 0 0 1-.6.8v.5h.1l1 1.4.4.3c.5.4 1 .8 1.6 1l.2.1a1.4 1.4 0 0 0 .3.1l.3-.1.8-1 .3-.1h.2l1.4.7.6.2.2.3v.4l-.2.7-.2.3a2.4 2.4 0 0 1-.5.4 5 5 0 0 1-.4.2 2 2 0 0 1-.8.2h-1.1c-1.4-.4-2.7-1.1-3.8-2.1l-.7-.6a9.5 9.5 0 0 1-2-2.8c-.2-.4-.3-.9-.3-1.4 0-.6.2-1.2.6-1.7l.2-.3c.2 0 .2-.1.3-.2h.4Z"/>'),
    telegram: createSvgIcon('<path d="m17 7.1 1.1-.3V7c-.2 2.5-1.2 8.5-1.7 11.3-.2.7-.2 1-.9.6l-1.2-.8-3-2.1c-1.3-.9-.8-1.4 0-2 0-.2.2-.3.3-.4l.7-.7c1.2-1.1 3.5-3.2 3.5-3.5v-.2A158.5 158.5 0 0 0 9 13.3a3 3 0 0 1-1.7.6l-2-.6-1.3-.4-.3-.1A739.2 739.2 0 0 1 17.1 7Zm2.5-1.9c-.2-.2-.5-.3-.7-.3h-.5c-.5 0-1 0-1.9.4L12 7a750.7 750.7 0 0 0-10.3 4.6c-.2.2-.6.5-.7 1 0 .5 0 .9.3 1.2l.7.5 1.1.4 1.7.5c1.8.6 3.3 1 4.9 2l3.5 2.5 1.3.8a3 3 0 0 0 1.9.5c1.1-.1 1.7-1.2 2-2.4A187.3 187.3 0 0 0 20 6.3c0-.2-.1-.7-.6-1Z"/>'),
    instagram: createSvgIcon('<circle cx="12" cy="12" r="4"></circle> <rect width="20" height="20" x="2" y="2" rx="5"></rect><path d="M17.5 6.5h0"></path>', '0 0 24 24', 'i i-instagram'),
    youtube: createSvgIcon('<path d="M1.5 17q-1-5.5 0-10Q1.9 4.8 4 4.5q8-1 16 0 2.1.3 2.5 2.5 1 4.5 0 10-.4 2.2-2.5 2.5-8 1-16 0-2.1-.3-2.5-2.5Zm8-8.5v7l6-3.5Z"></path>', '0 0 24 24', 'i i-youtube'),
    tiktok: createSvgIcon('<path d="M22 6v5q-4 0-6-2v7a7 7 0 1 1-5-6.7m0 6.7a2 2 0 1 0-2 2 2 2 0 0 0 2-2V1h5q2 5 6 5"></path>', '0 0 24 24', 'i i-tiktok'),
    windows: createSvgIcon('<path d="M21 13v5a3 3 0 0 1-2.7 3h-.1a1 1 0 0 1-.4 0h-.1l-4.7-.6V13zm-10 0v7.2l-5.3-.7A3 3 0 0 1 3 16.6V13zm0-9.2V11H3V7.4a3 3 0 0 1 2.5-2.9zM21 6V11h-8V3.6l4.7-.6A3 3 0 0 1 21 5.9"/>'),
    android: createSvgIcon('<path d="M6.4 4a9 9 0 0 1 11.2 0l1.5-1.5L20.5 4 19 5.4a9 9 0 0 1 2 5.6v1H3v-1c0-2.1.7-4 2-5.6L3.5 3.9 5 2.5 6.4 4ZM3 14h18v7c0 .6-.4 1-1 1H4a1 1 0 0 1-1-1v-7Zm6-5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm6 0a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"/>'),
    apple: createSvgIcon('<path d="M15 6h.3c1.4.1 3.5 1 4.5 2.6a1 1 0 0 1-.3 1.4l-.5.3a4.2 4.2 0 0 0-.7.4c-.7.4-1 1-1 1.7 0 .9.4 1.4 1 1.8.1.2.4.3.6.4h.4a1 1 0 0 1 .7 1c0 2.6-3 6.4-5.3 6.4-.8 0-1.3 0-2-.3-.5-.2-.8-.2-1.2-.2-.5 0-.9 0-1.5.2h-.2l-1.5.3C5.5 22 3 17 3 13s1.8-7 5.3-7l.9.1 1.3.5 1 .5 1-.5c1.1-.4 2-.7 2.8-.6h-.2zM14 1a1 1 0 0 1 1 1 3 3 0 0 1-3 3 1 1 0 0 1-1-1 3 3 0 0 1 3-3z"/>'),
    loading: createSvgIcon('<path d="M12 4a8 8 0 108 8h4A12 12 0 1112 0Z"/>', '0 0 24 24', 'loading-icon')
  };

  const audio = new Audio();
  audio.crossOrigin = 'anonymous';
  const playerPlay = document.querySelector('.player-button-play');
  const player = document.querySelector('.player');
  let isPlaying = false;
  function play(changeAudio = false) {
    audio.load();
    if (!isPlaying || changeAudio) {
      player.classList.add('is-loading');
      playerPlay.setAttribute('aria-label', 'Loading');
      playerPlay.innerHTML = svgIcons.loading;
    }
    audio.play().then(() => {
      player.classList.remove('is-loading');
      isPlaying = true;
      playerPlay.innerHTML = svgIcons.stop;
      player.classList.add('is-playing');
      playerPlay.setAttribute('aria-label', 'Pausar');
      playerPlay.setAttribute('aria-pressed', 'true');
    }).catch(error => {
      console.error('Error playing audio:', error);
    });
  }
  function pause() {
    if (!isPlaying) return;
    audio.pause();
    isPlaying = false;
    playerPlay.innerHTML = svgIcons.play;
    player.classList.remove('is-playing');
    playerPlay.setAttribute('aria-label', 'Reproducir');
    playerPlay.setAttribute('aria-pressed', 'false');
  }

  // Handle play/pause button click
  function handlePlayPause() {
    playerPlay.onclick = () => {
      if (audio.paused) {
        play();
        return;
      }
      pause();
    };
  }
  function initAudio(url) {
    audio.src = url;
    handlePlayPause();
  }

  const pixel = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==';

  // Asignar solo si localStorage está disponible
  // @param {string} key - Clave del localStorage
  // @param {string} value - Valor del localStorage
  function safeLocalStorage(key, value = null) {
    try {
      if (value !== null) {
        localStorage.setItem(key, value);
      } else {
        return localStorage.getItem(key);
      }
    } catch (error) {
      console.warn('LocalStorage no está disponible', error);
      return null;
    }
  }

  // Set attributes
  // @param {HTMLElement} element - element
  // @param {Object} attributes - attributes
  // @returns {void}
  const setAttributes = (element, attributes) => {
    for (const key in attributes) {
      element.setAttribute(key, attributes[key]);
    }
  };

  // Create embed
  // @param {string} url - url
  // @param {Object} params - attributes
  // @returns {HTMLIFrameElement} - iframe element
  function createEmbed({
    url,
    params = {}
  }) {
    const $iframe = document.createElement('iframe');
    $iframe.src = url;
    $iframe.frameborder = 0;
    setAttributes($iframe, params);
    return $iframe;
  }

  // Get video info
  // @param {string} url - url
  // @returns {Promise<string>} - title
  async function getVideoInfo(videoId) {
    const data = await fetch(`https://noembed.com/embed?dataType=json&url=https://www.youtube.com/watch?v=${videoId}`);
    return data.json();
  }

  // Convertir a tiempo relativo
  function timeAgo(date) {
    const getSecondsDiff = timestamp => (Date.now() - timestamp) / 1000;

    // Unidades de tiempo
    const DATE_UNITS = {
      day: 86400,
      hour: 3600,
      minute: 60,
      second: 1
    };

    // Obtener unidad y valor de la fecha
    const getUnitAndValueDate = secondsElapsed => {
      for (const [unit, secondsInUnit] of Object.entries(DATE_UNITS)) {
        if (secondsElapsed >= secondsInUnit || unit === 'second') {
          const value = Math.floor(secondsElapsed / secondsInUnit) * -1;
          return {
            value,
            unit
          };
        }
      }
    };

    // Obtener tiempo relativo
    const getTimeAgo = timestamp => {
      const rtf = new Intl.RelativeTimeFormat();
      const secondsElapsed = getSecondsDiff(timestamp);
      const {
        value,
        unit
      } = getUnitAndValueDate(secondsElapsed);
      return rtf.format(value, unit);
    };

    // Resultado
    const reference = new Date(date);
    return getTimeAgo(reference);
  }

  // Truncate a string to a specified length and add ellipsis if necessary
  // @param {string} str - The string to truncate
  // @param {number} length - The maximum length of the truncated string
  // @returns {string} The truncated string with ellipsis if needed
  function truncate(str, length) {
    if (typeof str !== 'string' || length <= 0) return '';
    return str.length > length ? `${str.slice(0, length)}...` : str;
  }

  // Remove HTML tags from a string
  // @param {string} html - The HTML string
  // @returns {string} The string without HTML tags
  function removeTags(html) {
    return html.replace(/<[^>]*>?/g, '');
  }

  // Generate a unique ID for a channel based on its name
  // @param {string} str - The channel name
  function idGenerator(str) {
    return `channel-${str.replace(/\s+/g, '-').toLowerCase()}`;
  }

  const range = document.querySelector('.volume-range-input');
  const rangeFill = document.querySelector('.volume-range-fill');
  const rangeWrapper = document.querySelector('.volume-range-wrapper');
  const rangeThumb = document.querySelector('.volume-range-thumb');
  const volumeToggle = document.querySelector('.volume-toggle');
  const currentVolume = safeLocalStorage('volume') || 100;

  // Actualizar el estilo del range y thumb
  // @param {number} percent - Porcentaje del rang
  function updateRangeStyle(percent) {
    const rangeDimensions = {
      width: rangeWrapper.offsetWidth,
      height: rangeWrapper.offsetHeight
    };
    {
      rangeFill.removeAttribute('style');
      rangeThumb.removeAttribute('style');
      rangeFill.style.height = `${percent}%`;
      rangeThumb.style.bottom = `${percent / 100 * (rangeDimensions.height - rangeThumb.offsetWidth)}px`;
    }
  }

  // Actualizar el volumen
  // @param {number} value - Valor del volumen
  function updateVolume(value) {
    range.value = value;
    updateRangeStyle(value);
    safeLocalStorage('volume', value);
    audio.volume = value / 100;
    volumeToggle.innerHTML = parseInt(value) === 0 ? svgIcons.volumeOff : value < 50 ? svgIcons.volumeLow : svgIcons.volumeHigh;
  }

  // Calcular el valor basado en el evento y el rango
  // @param {MouseEvent} event - Evento de ratón
  // @returns {number} - Valor calculado
  function calculateValueFromEvent(event) {
    const rangeRect = range.getBoundingClientRect();
    const clickX = event.clientY - rangeRect.top;
    let percent = clickX / range.offsetWidth * 100;
    percent = 100 - percent;
    percent = Math.max(0, Math.min(100, percent));
    return Math.round((range.max - range.min) * (percent / 100)) + parseInt(range.min);
  }

  // Manejar el arrastre del pulgar
  // @param {MouseEvent} event - Evento de ratón
  function handleThumbDrag(event) {
    const value = calculateValueFromEvent(event);
    updateVolume(value);
  }

  // Manejar el clic en el rango
  // @param {MouseEvent} event - Evento de ratón
  function handleRangeClick(event) {
    const value = calculateValueFromEvent(event);
    updateVolume(value);
  }

  // Inicializar los controles de volumen
  // @returns {void}
  function initVolumeControl() {
    if (!range || !rangeFill || !rangeWrapper || !rangeThumb || !volumeToggle) {
      console.warn('Volume controls elements not found');
      return;
    }
    updateVolume(currentVolume);
    let isDragging = false;
    range.addEventListener('input', event => {
      updateVolume(event.target.value);
    });
    rangeThumb.addEventListener('mousedown', () => {
      isDragging = true;
      document.addEventListener('mousemove', handleThumbDrag);
    });
    document.addEventListener('mouseup', () => {
      if (isDragging) {
        isDragging = false;
        document.removeEventListener('mousemove', handleThumbDrag);
      }
    });
    rangeWrapper.addEventListener('click', handleRangeClick);
    volumeToggle.addEventListener('click', () => {
      updateVolume(audio.volume > 0 ? 0 : 100);
    });
  }

  const STREAMS = window?.streams || {};
  const config = {
    timeRefresh: STREAMS.timeRefresh || 10000,
    programRefresh: STREAMS.programRefresh || 60000,
    baseUrl: STREAMS.base_url || 'https://nexoadmin.com/panelradiotv/server/public/',
    idUser: STREAMS.id_user || 2,
    service: STREAMS.service || 'deezer',
    marqueeSpeed: STREAMS.marqueeSpeed || 12,
    marqueeGap: STREAMS.marqueeGap || '2vw'
  };

  const normalizeData = data => {
    const name = data.radio_nombre || data.multiradio_nombre;
    const description = data.radio_descripcion || data.multiradio_descripcion || 'no description';
    const picture = config.baseUrl + (data.radio_fondo || data.multiradio_imagen);
    const cover = config.baseUrl + (data.radio_splash || data.multiradio_imagen);
    const stream = data.radio_url || data.multiradio_url;
    const video = data.radio_video || data.multiradio_tvstream || null;
    const whatsapp = data.radio_whatsapp || data.multiradio_whatsapp || null;
    const facebook = data.radio_facebook_url || data.multiradio_facebook || null;
    const web = data.radio_web || data.multiradio_web || null;
    const youtube = data.radio_youtube || data.multiradio_youtube || null;
    const instagram = data.radio_instagram || data.multiradio_instagram || null;
    const tiktok = data.radio_tiktok || data.multiradio_tiktok || null;
    return {
      name,
      description,
      picture,
      cover,
      stream,
      video,
      whatsapp,
      facebook,
      web,
      youtube,
      instagram,
      tiktok
    };
  };
  function createQuery(data) {
    const title = data.title || data.song || 'No Title';
    return title.trim() !== '' ? `${data.artist} - ${title}` : `${data.name} - ${data.description}`;
  }

  // Set default data for search results
  // @param {Object} params - Parameters containing streamData, searchData, and station
  // @returns {Object} Updated searchData with fallback values
  const setDefaultData = ({
    streamData,
    searchData,
    station
  }) => {
    const fallbackTitle = streamData.title ?? streamData.song ?? searchData.title ?? searchData.song ?? station.name;
    const fallbackArtist = streamData.artist ?? searchData.artist ?? station.description;
    searchData.title = fallbackTitle === '' ? station.name : fallbackTitle;
    searchData.artist = fallbackArtist === '' ? station.description : fallbackArtist;
    searchData.artist_artwork = searchData.artist_artwork || station.picture;
    const defaultArtwork = searchData.artwork || station.picture;
    if (searchData.artwork) {
      searchData.artwork = {
        small: searchData?.artwork?.small || defaultArtwork,
        medium: searchData?.artwork?.medium || defaultArtwork,
        large: searchData?.artwork?.large || defaultArtwork,
        xl: searchData?.artwork?.xl || defaultArtwork
      };
    } else {
      searchData.artwork = {
        small: station.picture,
        medium: station.picture,
        large: station.picture,
        xl: station.picture
      };
    }
    return searchData;
  };

  // @param {HTMLElement} item - Elemento que contiene el texto
  function scrollText(item) {
    if (!item) return;
    const parent = item.parentElement;
    if (!parent) return;
    const parentWidth = parent.offsetWidth;
    const itemWidth = item.scrollWidth;
    const marqueeGap = config.marqueeGap;

    // Verificar si ya se está aplicando el efecto de scroll para evitar duplicaciones
    const isScrolling = item.classList.contains('is-infinite-scrolling');
    if (itemWidth > parentWidth) {
      if (!isScrolling) {
        // Guardar el contenido original antes de duplicarlo
        item.dataset.originalText = item.innerHTML || item.innerText;
        item.innerHTML = `<span>${item.dataset.originalText}</span>   <span>${item.dataset.originalText}</span>`;
        item.classList.add('is-infinite-scrolling');
      }
      const scroll = item.scrollWidth - parentWidth;
      const duration = 5000 + scroll * (config.marqueeSpeed);
      {
        item.style.setProperty('--marquee-gap', `${marqueeGap === 'auto' ? parentWidth + 'px' : marqueeGap}`);
      }
      item.style.setProperty('--text-scroll-duration', `${duration}ms`);
    } else {
      removeTextScroll(item);
    }
  }

  // Restaurar el texto original y quitar animación
  function removeTextScroll(item) {
    if (!item) return;
    if (item.classList.contains('is-infinite-scrolling')) {
      item.innerHTML = item.dataset.originalText || item.innerText;
      item.removeAttribute('data-original-text');
      item.classList.remove('is-infinite-scrolling', 'is-backwards');
    }
  }

  // Observar cambios en el tamaño del contenedor
  function observeTextScroll(item) {
    if (!item || !item.parentElement) return;
    removeTextScroll(item);
    const resizeObserver = new ResizeObserver(() => scrollText(item));
    resizeObserver.observe(item.parentElement);
    item._resizeObserver = resizeObserver;
    scrollText(item);
  }

  // Devolver una promesa para saber si la imagen se ha cargado correctamente
  // @param {string} src - URL de la imagen
  // @returns {Promise} - Promesa que se resuelve si la imagen se carga correctamente
  function loadImage(src) {
    return new Promise((resolve, reject) => {
      const img = new Image();
      img.onload = () => resolve(img);
      img.onerror = reject;
      img.src = src;
    });
  }

  // Agrega una transición de deslizamiento a la imagen
  // @param {HTMLElement} container - Contenedor de la imagen
  // @param {string} src - URL de la imagen
  function slideUpImageTransition(container, src) {
    return new Promise(resolve => {
      const img = document.createElement('img');
      const size = container.clientHeight;
      img.src = src;
      img.width = size;
      img.height = size;
      img.style.top = '100%';
      container.appendChild(img);
      const lastImg = container.querySelector('img:last-child');
      setTimeout(() => {
        lastImg.style.top = 0;
      }, 100);
      lastImg.addEventListener('transitionend', () => {
        const allImgExcLast = container.querySelectorAll('img:not(:last-child)');
        allImgExcLast.forEach(img => img.remove());
        resolve(); // Resolvemos la promesa cuando termina la animación
      }, {
        once: true
      });
    });
  }

  // import { checkDomain } from './checkDomain'

  const container$3 = document.getElementById('footer-socials');
  const watsappContainer = document.getElementById('whatsapp-container');
  const headerSocials = document.getElementById('header-socials');

  // Obtener las redes sociales del objeto data
  // @param {object} data - Datos de la radio
  function getSocials(data) {
    return Object.fromEntries(Object.entries({
      whatsapp: data.whatsapp,
      facebook: data.facebook,
      youtube: data.youtube,
      instagram: data.instagram,
      tiktok: data.tiktok
    }).filter(([_, value]) => value != null));
  }

  // Establecer el botón de WhatsApp
  // @param {string} watsappUrl - URL de WhatsApp
  function setWatsappBtn(watsappUrl) {
    if (!watsappContainer) return;
    watsappContainer.innerHTML = `<a href="${watsappUrl}" target="_blank" class="watsapp-btn">
    ${svgIcons.whatsapp}
  </a>`;
    watsappContainer.classList.add('is-active');
  }

  // Establecer las redes sociales
  // @param {HTMLElement} container - Contenedor de las redes sociales
  // @param {object} data - Datos de las redes sociales
  function setSocial(data) {
    if (!container$3 || !data) return;
    const socialData = getSocials(data);
    const socialItems = Object.keys(socialData).map(key => {
      return `<a href="${socialData[key]}" target="_blank" class="social-item social-${key}">
      ${svgIcons[key]}
    </a>`;
    });

    // await checkDomain()

    container$3.innerHTML = socialItems.join('');
    headerSocials.innerHTML = socialItems.join('');
    if (socialData.whatsapp) {
      setWatsappBtn(socialData.whatsapp);
    } else {
      watsappContainer.classList.remove('is-active');
    }
  }

  const modal = document.querySelector('.modal');
  const modalBody = modal.querySelector('.modal-body');
  const OPEN_CLASS = 'is-open';
  let currentVideo = null;
  function initVideoPlayer(videoUrl) {
    const $video = document.createElement('video');
    $video.id = 'player';
    $video.classList.add('video-js', 'video-js-stream');
    modalBody.innerHTML = '';
    modalBody.appendChild($video);
    const videoId = document.getElementById('player');

    // eslint-disable-next-line no-undef
    currentVideo = videojs(videoId, {
      sources: [{
        src: videoUrl,
        type: 'application/x-mpegURL'
      }],
      controls: true,
      autoplay: true
    });
  }
  function initYoutubePlayer(youtubeId) {
    const embedUrl = `https://www.youtube.com/embed/${youtubeId}?autoplay=1&rel=0`;
    const $iframe = createEmbed({
      url: embedUrl,
      params: {
        allowfullscreen: '1',
        class: 'ytube-embed'
      }
    });
    modalBody.innerHTML = '';
    modalBody.appendChild($iframe);
  }
  function createShareButton(name, url) {
    const $a = document.createElement('a');
    $a.className = `player-social-link player-social-link-${name}`;
    $a.href = url;
    $a.target = '_blank';
    $a.innerHTML = svgIcons[name];
    return $a;
  }
  function initShareModal({
    artist,
    title,
    artwork
  }) {
    const shareUrl = window.location.href;
    const shareText = `Estoy escuchando ${title} de ${artist} en ${shareUrl}`;
    modalBody.innerHTML = `
    <h2 class="fw-800 mb-0.75">COMPARTIR</h2>
    <img src="${artwork}" alt="portada modal" class="player-modal-image" width="200" height="200">
    <div class="fs-4 fw-500 song-name">${title}</div>
    <span class="fs-5">${artist}</span>
    <div class="flex g-0.5 justify-center modal-social player-socials wrap">
      ${createShareButton('facebook', `https://www.facebook.com/sharer/sharer.php?u=${shareUrl}`).outerHTML}
      ${createShareButton('x', `https://twitter.com/intent/tweet?text=${encodeURIComponent(shareText)}`).outerHTML}
      ${createShareButton('whatsapp', `https://api.whatsapp.com/send?text=${encodeURIComponent(shareText)}`).outerHTML}
    </div>
  `;
  }
  function createForm(formAction, formId) {
    modalBody.innerHTML = `
    <form id="${formId}" action="${formAction}" method="POST" class="modal-form">
      <input type="text" name="name" placeholder="Nombre" required>
      <input type="email" name="email" placeholder="Correo" required>
      <input type="tel" name="contact" placeholder="Teléfono" required>
      <textarea name="message" placeholder="Mensaje" required></textarea>
      <input type="hidden" name="promo" value="${formId}">
      <button type="submit" class="btn btn-full btn-primary btn-input">Enviar</button>
    </form>
  `;
    const $form = modalBody.querySelector('form');
    $form.addEventListener('submit', async e => {
      e.preventDefault();
      const formData = new FormData($form);
      const response = await fetch(formAction, {
        method: 'POST',
        body: formData
      });
      document.body.classList.add(response.ok ? 'modal-success' : 'modal-error', 'modal-message');
      setTimeout(() => document.body.classList.remove('modal-success', 'modal-error', 'modal-message'), 3000);
      if (response.ok) $form.reset();
    });
  }
  function openLyricsModal(lyrics) {
    modalBody.innerHTML = `
    <div class="lyrics-header">
      <h2 class="modal-lyrics-title m:fs-3 fs-5 fw-500">Letra</h2>
    </div>
    <pre>${lyrics || 'No se encontraron letras'}</pre>
  `;
  }
  function openSongModal({
    artist,
    title,
    artwork,
    genre,
    album
  }) {
    const artworkUrl = artwork?.medium || artwork?.large || artwork?.small;
    modalBody.innerHTML = `<div class="modal-song-content">
    <img src="${artworkUrl}" alt="portada modal" class="modal-song-image" width="200" height="200">
    <h3 class="modal-song-title">${title}</h3>
    <div class="modal-song-meta">
      <div class="modal-song-info"><strong>Artista: </strong>${artist}</div>
      <div class="modal-song-info"><strong>Genero: </strong>${genre}</div>
      <div class="modal-song-info"><strong>Album: </strong>${album}</div>
    </div>
  </div>
  `;
  }
  function openFullModal({
    titulo,
    contenido,
    imagen,
    time
  }) {
    document.body.classList.add('modal-article');
    modalBody.innerHTML = `
    <div class="modal-article-title">
      <h2 class="fs-5 fw-800 m:fs-2">${titulo}</h2>
      <span class="fs-5">${time}</span>
    </div>
    <div class="modal-article-content">
      ${contenido}
    </div>
  `;
  }
  function openModal(type, options = {}) {
    if (!modal) return;
    modal.classList.add(OPEN_CLASS);
    modalBody.innerHTML = '';
    modal.classList.add(`modal-${type}`);
    switch (type) {
      case 'youtube':
        initYoutubePlayer(options.data?.youtube);
        break;
      case 'video':
        initVideoPlayer(options.url);
        break;
      case 'share':
        initShareModal(options.data);
        break;
      case 'form':
        createForm(options.formAction, options.formId);
        break;
      case 'lyrics':
        openLyricsModal(options.lyrics);
        break;
      case 'song':
        openSongModal(options.data);
        break;
      case 'article':
        openFullModal(options.data);
        break;
      default:
        console.warn('Tipo de modal desconocido:', type);
        return;
    }
    function closeModal() {
      modal.classList.remove(OPEN_CLASS, `modal-${type}`);
      document.body.classList.remove('modal-article');
      if (currentVideo) currentVideo.dispose();
      modalBody.innerHTML = '';
      if (options.hook && typeof options.hook === 'function') {
        options.hook();
      }
    }
    modal.querySelector('.modal-close').addEventListener('click', closeModal);
    modal.querySelector('#close-video').addEventListener('click', closeModal);
    modal.addEventListener('click', e => {
      if (!modal.querySelector('.modal-content').contains(e.target)) closeModal();
    });
  }

  // import { changeMultiTextContent } from '../utils'

  const playerTitle = document.querySelector('.player-title');
  const stationName = document.querySelectorAll('.station-name');
  const artistName = document.querySelector('.artist-name');
  const stationDesc = document.querySelector('.station-desc');
  const imageChange = document.querySelectorAll('.image-change');
  const stationTv = document.querySelector('.station-tv');
  const songProgressContainer = document.querySelector('.song-progress-container');
  const docTitle = document.title;
  function setStationInfo(data) {
    setSocial(data);
    removeTextScroll(playerTitle);
    if (stationTv) {
      stationTv.classList.remove('is-loaded');
      stationTv.onclick = null;
    }
    stationName.forEach(el => {
      el.textContent = data.name || data.title || 'Sin título';
    });
    stationDesc.innerHTML = `<strong>${data.description || data.subtitle || 'Sin descripción'}</strong>`;
    artistName.innerHTML = 'Cargando';
    imageChange.forEach(el => {
      const img = el.querySelector('img:first-child');
      if (img) {
        img.src = data.picture;
      }
    });
    if (stationTv && data.video) {
      stationTv.classList.add('is-loaded');
      stationTv.onclick = () => {
        openModal('video', {
          url: data.video,
          hook: () => play()
        });
        pause();
      };
    }
  }

  // Set current song data
  // @param {Object} data - Song data
  // @param {string} picture - URL of the picture
  function setCurrentSong(data, picture) {
    const {
      title,
      artist,
      artwork
    } = data;
    removeTextScroll(playerTitle);
    if (artistName) {
      artistName.textContent = artist || 'Sin artista';
    }
    playerTitle.innerHTML = `<strong>${title || 'Sin título'}</strong><span class="inline-artist-name">  - ${artist || 'Sin artista'}</span>`;
    observeTextScroll(playerTitle);
    document.title = `${title} - ${artist} | ${docTitle}`;
    const coverUrl = artwork?.xl || artwork?.large || artwork || picture;
    const $img = document.createElement('img');
    $img.src = coverUrl;
    imageChange.forEach(el => {
      loadImage(coverUrl).then(() => {
        slideUpImageTransition(el, coverUrl);
      }).catch(() => {
        console.error('Error loading image');
      });
    });
  }
  function convertSecondsToMinutes(seconds) {
    const minutes = Math.floor(seconds / 60);
    const remainingSeconds = seconds % 60;
    return `${minutes}:${remainingSeconds.toFixed(0) < 10 ? '0' : ''}${remainingSeconds.toFixed(0)}`;
  }

  // Obtener porcentaje entre dos valores
  function getPercentage(value, total) {
    return value * 100 / total;
  }
  function songProgress({
    duration,
    elapsed
  }) {
    const progress = getPercentage(elapsed, duration);

    // Agregar la variable css con el progreso de la canción
    songProgressContainer.style.setProperty('--song-progress', `${2 + progress}%`);

    // Actualizar el progreso de la canción
    const songElapsed = document.querySelector('.song-elapsed');
    const songDuration = document.querySelector('.song-duration');
    if (songElapsed) {
      songElapsed.textContent = convertSecondsToMinutes(elapsed);
    }
    if (songDuration) {
      songDuration.textContent = convertSecondsToMinutes(duration);
    }
  }

  // Establecer un ecualizador falso para la vista previa del reproductor
  // @returns {void}
  function setFakeEqualizer() {
    const equalizer = document.querySelector('.player-equalizer');
    const barsCount = 50;
    if (!equalizer) return;

    // Crea todas las barras del ecualizador
    for (let i = 0; i < barsCount; i++) {
      const bar = document.createElement('div');
      bar.classList.add('equalizer-bar');
      equalizer.appendChild(bar);
    }
  }

  // Cargar datos de la canción actual al navegador
  function setMediaSession(data, picture) {
    if (!('mediaSession' in navigator)) {
      return;
    }
    const {
      artist,
      artwork
    } = data;
    const title = data.title || data.song;
    const artworkUrl = artwork?.large || artwork?.medium || artwork?.small;
    navigator.mediaSession.metadata = new MediaMetadata({
      title,
      artist,
      artwork: [{
        src: artworkUrl,
        sizes: '128x128',
        type: 'image/png'
      }, {
        src: artworkUrl,
        sizes: '256x256',
        type: 'image/png'
      }, {
        src: artworkUrl,
        sizes: '512x512',
        type: 'image/png'
      }]
    });
    navigator.mediaSession.setActionHandler('play', () => {
      play();
    });
    navigator.mediaSession.setActionHandler('pause', () => {
      pause();
    });
  }

  const container$2 = document.getElementById('last-played');

  // Establecer las canciones que se han reproducido
  // @param {Array} data - Array de objetos con los datos de las canciones
  // @param {Object} current - Objeto con los datos de la canción actual
  // @param {string} SERVICE - Nombre del servicio de música
  // @returns {void}
  async function setHistory(data, station) {
    if (!container$2 || !data) return;
      const historyCurrentData = [];
    // Cargar datos de la canción actual al navegador
    data = data.slice(0, 6); 
    const itemsHTML = await Promise.all(data.map(async (song, index) => {
      const item = song.song;
      const query = createQuery(item);
      const searchData = await getDataFromSearchApi(query, station.searchApi || 'auto');
      const songData = setDefaultData({
        streamData: item,
        searchData,
        station
      });
      const {
        artwork
      } = songData;
      const imageUrl = artwork?.medium || artwork?.large || station.picture;
      songData.imageUrl = imageUrl;
      historyCurrentData[index] = songData;
      return `
        <div class="history" data-index="${index}">
          <div class="history-wrapper">
            <div class="history-data">
              <img class="history-art" src="${imageUrl}" alt="${songData.title}">
              <div class="history-meta">
                <div class="history-title truncate-line">${songData.title}</div>
                <div class="history-artist truncate-line">${songData.artist}</div>
              </div>
              <button class="history-button"></button>
            </div>
            ${songData.youtube !== null ? `
            <div class="history-youtube">
              ${svgIcons.playAlt}
              <img class="history-icon" src="https://i.ytimg.com/vi/${songData.youtube}/mqdefault.jpg" alt="thumbnail">
              <button class="history-youtube-button"></button>
            </div>
            ` : ''}
          </div>
          <div class="history-bg" style="background-image: url('${imageUrl}')"></div>
        </div>`;
    }));
    container$2.innerHTML = itemsHTML.join('');
    const historyItemsElements = container$2.querySelectorAll('.history');
    historyItemsElements.forEach(item => {
      const button = item.querySelector('.history-button');
      const index = item.getAttribute('data-index');
      button.addEventListener('click', event => {
        // Abrir modal con la canción seleccionada
        event.preventDefault();
        openModal('song', {
          data: historyCurrentData[index]
        });
      });
      const youtubeButton = item?.querySelector('.history-youtube-button');
      youtubeButton?.addEventListener('click', event => {
        event.preventDefault();
        if (!historyCurrentData[index].youtube) return;
        openModal('youtube', {
          data: historyCurrentData[index]
        });
      });
    });
  }

  const CONTAINER_LIST = document.querySelector('.videoTops-list');
  let currentIframeActive = null;
  const cache = localStorage.getItem('videoTops') ? JSON.parse(localStorage.getItem('videoTops')) : {};
  async function fetchVideoList(data) {
    if (!CONTAINER_LIST) return;
    const items = data.length > 5 ? data.slice(0, 5) : data;
    for (const item of items) {
      const videoInfo = cache[item.video_url] || (await getVideoInfo(item.video_url));
      const $li = createVideoListItem(item.video_url, videoInfo);
      CONTAINER_LIST.appendChild($li);
      addEventListeners($li, item.video_url);
      cache[item.video_url] = videoInfo;
      localStorage.setItem('videoTops', JSON.stringify(cache));
    }
    const $firstVideo = CONTAINER_LIST.querySelector('.videoTops-load-iframe');
    if ($firstVideo) {
      $firstVideo.click();
    }
  }
  function createVideoListItem(videoId, videoInfo) {
    const $div = document.createElement('div');
    const videoThumbnail = videoInfo.thumbnail_url.replace('hqdefault', 'mqdefault');
    $div.className = 'videoTops-item';
    $div.innerHTML = `
    <div class="videoTops-content" data-video-id="${videoId}">
      <div class="videoTops-element">
        <img src="${videoThumbnail}" alt="${videoInfo.title}">
        <div class="videoTops-info">
          <h3>${videoInfo.title}</h3>
          <p>${videoInfo.author_name}</p>
        </div>
        <button class="videoTops-load-iframe"></button>
      </div>
      <div class="videoTops-iframe"></div>
    </div>
  `;
    return $div;
  }
  function addEventListeners($li, videoId) {
    $li.querySelector('.videoTops-load-iframe').addEventListener('click', function () {
      handleLoadIframeButtonClick($li, videoId);
    });
  }
  function handleLoadIframeButtonClick($li, videoId) {
    const $iframe = createEmbed({
      url: `https://www.youtube.com/embed/${videoId}`,
      params: {
        allowfullscreen: '1',
        class: 'ytube-embed'
      }
    });
    if ($li.classList.contains('is-active')) return;
    $li.classList.add('is-active');
    if (currentIframeActive) {
      currentIframeActive.innerHTML = '';
      currentIframeActive.classList.remove('is-active');
      currentIframeActive.parentElement.parentElement.classList.remove('is-active');
    }
    const $iframeContainer = $li.querySelector('.videoTops-iframe');
    $iframeContainer.innerHTML = '';
    $iframeContainer.appendChild($iframe);
    currentIframeActive = $iframeContainer;
  }

  const container$1 = document.getElementById('channels');
  function renderStationButtons({
    stations,
    onStationChange
  }) {
    if (!container$1 || !stations?.length) return;
    container$1.innerHTML = ''; // Limpiar el contenedor antes de renderizar

    let currentActive = null;
    let currentStation = null;
    stations.forEach((station, index) => {
      const button = document.createElement('div');
      button.id = idGenerator(station.name);
      const picture = document.createElement('picture');
      const channelPlay = document.createElement('div');
      const channelInfo = document.createElement('div');
      const title = document.createElement('h3');
      const description = document.createElement('p');
      const descriptionEl1 = document.createElement('span');
      const descriptionEl2 = document.createElement('span');
      const img = document.createElement('img');
      const img2 = document.createElement('img');
      button.classList.add('channel-item', 'swiper-slide');
      picture.classList.add('channel-picture');
      channelPlay.classList.add('channel-play');
      channelInfo.classList.add('channel-info');
      title.classList.add('channel-title', 'truncate-line');
      description.classList.add('channel-description');
      img.classList.add('channel-image');
      img2.classList.add('channel-secondary-image');
      title.textContent = station.name;
      descriptionEl1.textContent = station.description;
      descriptionEl2.textContent = station.secondaryDescription || 'Cargando...';
      img.src = station.picture || config$1.defaultCover;
      img.alt = station.name || 'Estación de radio';
      img.width = 400;
      img.height = 400;
      img.loading = 'lazy';
      img.setAttribute('aria-hidden', 'true');
      img2.src = pixel;
      img2.alt = station.name || 'Estación de radio secundaria';
      img2.width = 400;
      img2.height = 400;
      img2.loading = 'lazy';
      img2.setAttribute('aria-hidden', 'true');
      channelPlay.innerHTML = svgIcons.play;
      channelPlay.setAttribute('aria-label', 'Reproducir');
      channelPlay.setAttribute('aria-pressed', 'false');
      channelPlay.setAttribute('role', 'button');
      description.appendChild(descriptionEl1);
      description.appendChild(descriptionEl2);
      button.appendChild(picture);
      picture.appendChild(img2);
      picture.appendChild(img);
      channelInfo.appendChild(title);
      channelInfo.appendChild(description);
      channelInfo.appendChild(channelPlay);
      button.appendChild(channelInfo);
      if (index === 0) {
        button.classList.add('is-current');
        channelPlay.setAttribute('aria-pressed', 'true');
        channelPlay.innerHTML = svgIcons.stop;
        currentActive = button;
      }
      let isLoading = false;
      button.addEventListener('click', async () => {
        if (currentStation === station || isLoading) return;
        isLoading = true;
        if (currentActive) {
          currentActive.classList.remove('is-current');
          const currentPlayButton = currentActive.querySelector('.channel-play');
          if (currentPlayButton) {
            currentPlayButton.setAttribute('aria-pressed', 'false');
            currentPlayButton.innerHTML = svgIcons.play;
          }
        }
        currentActive = button;
        currentActive.classList.add('is-current');
        const playButton = currentActive.querySelector('.channel-play');
        if (playButton) {
          playButton.setAttribute('aria-pressed', 'true');
          playButton.innerHTML = svgIcons.stop;
        }
        setStationInfo(station);
        await onStationChange(station);
        initAudio(station.stream);
        play();
        currentStation = station;
        isLoading = false;
      });
      container$1.appendChild(button);
      container$1.classList.add('is-loaded');
      async function updateStationNowPlaying() {
        const name = button.querySelector('.channel-description span:last-child');
        const image = button.querySelector('.channel-secondary-image');
        const streamData = await getStreamData(station.stream);
        const query = createQuery(streamData);
        const searchData = await getDataFromSearchApi(query, config$1.service);
        const songData = setDefaultData({
          streamData,
          searchData,
          station
        });
        const {
          artwork,
          title,
          artist
        } = songData || {};
        const imageUrl = artwork?.medium || artwork?.large || station.picture;
        name.textContent = `${title} - ${artist}`;
        image.src = imageUrl;
        setTimeout(updateStationNowPlaying, config$1.timeRefresh);
      }
      updateStationNowPlaying();
    });

    // eslint-disable-next-line no-undef, no-unused-vars
    new Swiper('.swiper-stations', {
      // Enabled autoplay mode
      autoplay: {
        delay: config$1.swiperDelay,
        disableOnInteraction: false
      },
      // If we need navigation
      navigation: {
        nextEl: '.swiper-next-stations',
        prevEl: '.swiper-prev-stations'
      },
      // Responsive breakpoints
      breakpoints: {
        480: {
          slidesPerView: 2,
          spaceBetween: 12
        },
        640: {
          slidesPerView: 4,
          spaceBetween: 12
        },
        1024: {
          slidesPerView: 5,
          spaceBetween: 12
        }
      }
    });
  }

  // Establecer el slider
  // @param {HTMLElement} container - Contenedor del slider
  // @param {Array} data - Datos de las imágenes
  // @param {string} baseUrl - URL base de las imágenes
  function setSlider(data, baseUrl) {
    const sliderContainer = document.getElementById('slider-slide');
    if (!sliderContainer || !data || data.length === 0) return;
    for (const item of data) {
      const div = document.createElement('div');
      div.classList.add('slider-slide', 'swiper-slide');
      div.innerHTML = `<a href="${item.slide_url}" target="_blank">
        <img src="${baseUrl}${item.slide_foto}" alt="Slide" class="slider-image" width="100%">
      </a>
    `;
      sliderContainer.appendChild(div);
    }
    sliderContainer.classList.add('is-loaded');

    // eslint-disable-next-line no-undef, no-unused-vars
    new Swiper('.swiper-banner', {
      slidesPerView: 1,
      spaceBetween: 0,
      // Enabled autoplay mode
      autoplay: {
        delay: config$1.swiperDelay,
        disableOnInteraction: false
      },
      // If we need navigation
      navigation: {
        nextEl: '.swiper-next-banner',
        prevEl: '.swiper-prev-banner'
      },
      pagination: {
        el: '.swiper-pagination-banner',
        clickable: true
      }
    });
  }

  function setTeamItems(data, baseUrl) {
    const teamContainer = document.getElementById('team');
    if (!teamContainer || !data) return;
    data = data.slice(0, 8);
    let index = 0;
    for (const item of data) {
      const equipoNombre = item.equipo_nombre;
      const equipoFoto = item.equipo_foto;
      const equipoDescripcion = item.equipo_descripcion;
      const article = document.createElement('article');
      article.classList.add('team-item', 'swiper-slide');
      article.style.setProperty('--fade-in-delay', `${index * 0.2 + 0.3}s`);
      article.innerHTML = `
      <div class="team-description">${equipoDescripcion}</div>
      <div class="team-image">
        <img src="${baseUrl}${equipoFoto}" alt="${equipoNombre}">
      </div>
      <div class="team-content">
        <h3 class="team-title">${equipoNombre}</h3>
      </div>
    `;
      teamContainer.appendChild(article);
      index++;
    }

    // eslint-disable-next-line no-undef, no-unused-vars
    new Swiper('.swiper-team', {
      // Enabled autoplay mode
      autoplay: {
        delay: config$1.swiperDelay,
        disableOnInteraction: false
      },
      // If we need navigation
      navigation: {
        nextEl: '.swiper-next-team',
        prevEl: '.swiper-prev-team'
      },
      // Responsive breakpoints
      breakpoints: {
        480: {
          slidesPerView: 2,
          spaceBetween: 12
        },
        640: {
          slidesPerView: 3,
          spaceBetween: 12
        },
        1024: {
          slidesPerView: 4,
          spaceBetween: 12
        }
      }
    });
  }

  // import { checkDomain } from './checkDomain'

  /* eslint-disable camelcase */
  // Función para obtener el día actual en formato de 2 letras
  function getCurrentDay() {
    const days = ['sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday'];
    const date = new Date();
    const day = date.getDay();
    return days[day];
  }
  function compareNumbers(a, b) {
    return Number(a) === Number(b);
  }
  function sortByDay(programas) {
    const resultado = {
      monday: [],
      tuesday: [],
      wednesday: [],
      thursday: [],
      friday: [],
      saturday: [],
      sunday: []
    };
    programas.forEach(programa => {
      const {
        prog_horario_lu,
        prog_horario_ma,
        prog_horario_mi,
        prog_horario_ju,
        prog_horario_vi,
        prog_horario_sa,
        prog_horario_do,
        prog_lu,
        prog_ma,
        prog_mi,
        prog_ju,
        prog_vi,
        prog_sa,
        prog_do,
        prog_titulo,
        prog_descripcion,
        prog_foto
      } = programa;
      const item = {
        titulo: prog_titulo,
        descripcion: prog_descripcion,
        foto: prog_foto,
        horario: null
      };

      // Verificar cada día y agregar al arreglo correspondiente si está activo
      if (compareNumbers(prog_lu, 1)) {
        item.horario = prog_horario_lu;
        resultado.monday.push({
          ...item
        });
      }
      if (compareNumbers(prog_ma, 1)) {
        item.horario = prog_horario_ma;
        resultado.tuesday.push({
          ...item
        });
      }
      if (compareNumbers(prog_mi, 1)) {
        item.horario = prog_horario_mi;
        resultado.wednesday.push({
          ...item
        });
      }
      if (compareNumbers(prog_ju, 1)) {
        item.horario = prog_horario_ju;
        resultado.thursday.push({
          ...item
        });
      }
      if (compareNumbers(prog_vi, 1)) {
        item.horario = prog_horario_vi;
        resultado.friday.push({
          ...item
        });
      }
      if (compareNumbers(prog_sa, 1)) {
        item.horario = prog_horario_sa;
        resultado.saturday.push({
          ...item
        });
      }
      if (compareNumbers(prog_do, 1)) {
        item.horario = prog_horario_do;
        resultado.sunday.push({
          ...item
        });
      }
    });

    // Ordenar los programas por hora en cada día
    Object.keys(resultado).forEach(dia => {
      resultado[dia].sort((a, b) => a.horario.localeCompare(b.horario));
    });
    return resultado;
  }

  // Compara la hora actual con la hora de inicio de un programa
  // @param {string} time - Hora de inicio del programa
  // @returns {number} - 1 si la hora actual es mayor, -1 si la hora actual es menor, 0 si son iguales
  function compareTime(time) {
    const date = new Date();
    const currentHour = date.getHours();
    const currentMinutes = date.getMinutes();
    const [programHour, programMinutes] = time.split(':').map(Number);
    if (currentHour > programHour || currentHour === programHour && currentMinutes > programMinutes) {
      return 1; // Hora actual es mayor
    } else if (currentHour < programHour || currentHour === programHour && currentMinutes < programMinutes) {
      return -1; // Hora actual es menor
    } else {
      return 0; // Horas iguales
    }
  }
  async function setSchedule(data, baseUrl) {
    const programs = sortByDay(data);
    const days = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];
    const tabs = document.querySelectorAll('.program-button');
    const tabsElements = document.querySelectorAll('.schedule-list');
    tabs.forEach(tab => {
      tab.onclick = event => {
        const target = event.target;
        const tabId = target.dataset.tab;
        tabs.forEach(tab => {
          tab.classList.remove('is-active');
        });
        tabsElements.forEach(tab => {
          tab.classList.remove('is-active');
        });
        const ul = document.getElementById(tabId);
        ul.classList.add('is-active');
        target.classList.add('is-active');
      };
    });

    // await checkDomain()

    days.forEach(day => {
      const ul = document.getElementById(`program-${day}`);
      ul.innerHTML = '';
      programs[day].forEach((item, index) => {
        const li = document.createElement('li');
        li.classList.add('schedule-item');
        li.style.setProperty('--fade-in-delay', `${index * 0.2 + 0.3}s`);
        li.innerHTML = `
        <div class="schedule-item-picture">
          <img src="${baseUrl}${item.foto}" alt="${item.titulo}">
        </div>
        <div class="schedule-item-content">
          <h3 class="schedule-item-title">${item.titulo}</h3>
          <p class="schedule-item-description">${item.horario} - ${item.descripcion}</p>
        </div>
      `;

        // Comparar la hora actual con la hora de inicio del programa
        const result = compareTime(item.horario);

        // Agregar la clase is-past si la hora actual es mayor
        // Solo agregar las clases si el programa es del día actual
        if (result > 0 && day === getCurrentDay()) {
          li.classList.add('is-past');
        }
        ul.appendChild(li);
      });

      // al ultimo elemento con la clase is-past agregarle la clase is-current
      // Solo si el día es el día actual
      const pastItems = document.querySelectorAll('.is-past');
      if (pastItems.length > 0 && day === getCurrentDay()) {
        pastItems[pastItems.length - 1].classList.add('is-current');
      }
    });

    // Mostrar el día actual
    const currentDay = getCurrentDay();

    // Mostrar el día actual
    const alltabs = document.querySelectorAll('.program-button');
    alltabs.forEach(tab => {
      tab.classList.remove('is-active');
    });
    const currentTab = document.querySelector(`[data-tab="program-${currentDay}"]`);
    currentTab.classList.add('is-active');
    const allLists = document.querySelectorAll('.schedule-list');
    allLists.forEach(list => {
      list.classList.remove('is-active');
    });
    const currentList = document.getElementById(`program-${currentDay}`);
    currentList.classList.add('is-active');
  }

  function setArticles(data, baseUrl) {
    const newsContainer = document.getElementById('news');
    const newsletterList = document.getElementById('newsletter-list');
    if (!newsContainer || !data) return;
    data = data.reverse();
    newsletterList.style.setProperty('--news-items', data.length);
    for (const item of data) {
      const {
        titulo,
        photo,
        contenido
      } = item;
      const time = new Date(item.created_at);
      const createdAt = timeAgo(time);
      const snippet = truncate(removeTags(contenido), 200);
      const article = document.createElement('article');
      article.classList.add('news-item', 'swiper-slide');
      article.innerHTML = `
      <div class="news-image">
        <img src="${baseUrl}${photo}" alt="${titulo}">
      </div>
      <div class="news-content">
        <h3 class="news-title">${titulo}</h3>
        <div class="news-divider">
          <p class="news-description">${snippet}</p>
          <time class="news-date">${createdAt}</time>
        </div>
      </div>
    `;
      article.addEventListener('click', () => {
        openModal('article', {
          data: {
            titulo,
            contenido,
            imagen: `${baseUrl}${photo}`,
            time: createdAt
          }
        });
      });
      newsContainer.appendChild(article);

      // Add to newsletter list
      const listItem = document.createElement('div');
      listItem.classList.add('newsletter-item', 'truncate', 'breaking-item');
      listItem.innerText = titulo;
      newsletterList.appendChild(listItem);
    }

    // eslint-disable-next-line no-undef, no-unused-vars
    // eslint-disable-next-line no-undef, no-unused-vars
    new Swiper('.swiper-news', {
      slidesPerView: 'auto',
      spaceBetween: 20,
      autoplay: false,
      navigation: {
        nextEl: '.swiper-next-news',
        prevEl: '.swiper-prev-news'
      },
      pagination: {
        el: '.swiper-pagination-articles',
        clickable: true
      }
    });
  }

  function setPromos(data, baseUrl, dataGetPromoUrl) {
    const container = document.getElementById('prm');
    if (!container || !data) return;
    if (data.length === 0) return;
    const button = document.querySelector('.station-prm');
    button.classList.add('is-loaded');
    data.forEach(item => {
      const img = document.createElement('img');
      img.src = baseUrl + item.photo;
      img.classList.add('prm-image');
      img.addEventListener('click', () => {
        openModal('form', {
          formAction: dataGetPromoUrl,
          formId: item.promocion_id
        });
      });
      container.appendChild(img);
    });
  }

  const container = document.getElementById('player-apps');

  // Obtener las aplicaciones del objeto data
  // @param {object} data - Datos de la radio
  function getApps(data) {
    const apps = {};
    if (data.radio_fondo_color) {
      apps.googlePlay = data.radio_fondo_color;
    }
    if (data.radio_splash_color) {
      apps.appStore = data.radio_splash_color;
    }
    return apps;
  }

  // Establecer las redes sociales
  // @param {HTMLElement} container - Contenedor de las aplicaciones
  // @param {object} data - Datos de las aplicaciones
  function setApps(data) {
    if (!container || !data) return;
    const appData = getApps(data);
    const appItems = Object.keys(appData).map(key => {
      return `<a href="${appData[key]}" target="_blank" class="app-item">
      ${svgIcons[key]}
    </a>`;
    });
    container.innerHTML = appItems.join('');
  }

  function setDeviceInfo() {
    const icons = {
      windows: svgIcons.windows,
      android: svgIcons.android,
      apple: svgIcons.apple
    };
    if (navigator.userAgent.match(/Android/i)) {
      return `${icons.android} Instalar en Android`;
    }
    if (navigator.userAgent.match(/iPhone|iPad|iPod/i)) {
      return `${icons.apple} Instalar en iOS`;
    }
    return `${icons.windows} Instalar en Windows`;
  }
  function installPWA() {
    const container = document.getElementById('install-container');
    const close = document.getElementById('close-install');
    const install = document.getElementById('install-pwa');
    const checkIosDevice = () => {
      const ua = navigator.userAgent;
      const vendor = navigator.vendor;
      const isSafari = /Safari/.test(ua) && /Apple Computer/.test(vendor) && !/CriOS/.test(ua); // Excluir Chrome

      return isSafari;
    };
    if (checkIosDevice()) return;
    if (!container) return;
    if (!install) return;
    close.addEventListener('click', () => {
      container.classList.remove('is-active');
    });
    install.innerHTML = setDeviceInfo();
    const isMobileDevice = () => {
      const mobileDeviceRegex = /Android|Windows Phone|Windows|iPhone|iPad|iPod|iOS|Macintosh/i;
      return mobileDeviceRegex.test(navigator.userAgent);
    };
    const isFirefox = () => {
      return navigator.userAgent.includes('Firefox');
    };
    let installPrompt = null;
    window.addEventListener('beforeinstallprompt', event => {
      event.preventDefault();
      installPrompt = event;
      if (isMobileDevice() && !isFirefox()) {
        container.classList.add('is-active');
      }
    });
    install.addEventListener('click', async () => {
      if (!installPrompt) {
        console.warn('No se puede instalar la PWA');
        return;
      }
      const result = await installPrompt.prompt();
      if (result.outcome === 'accepted') {
        console.warn('PWA instalada');
        container.classList.remove('is-active');
      } else {
        console.warn('PWA no instalada');
      }
    });
  }

  let currentQuery = '';
  let loadStations = [];
  let timeoutId;
  let timeoutIdProgram;
  const api = `${config$1.baseUrl}api/`;
  const mainFetchUrl = `${api}radio-app/${config$1.idUser}`;
  const multiradioFetchUrl = `${api}multiradio-app/${config$1.idUser}`;
  const dataVideoUrl = `${api}video-app/${config$1.idUser}`;
  const dataTeamUrl = `${api}equipo-app/${config$1.idUser}`;
  const dataProgramUrl = `${api}programa-app/${config$1.idUser}`;
  const dataSlideUrl = `${api}slide-app/${config$1.idUser}`;
  const dataNoticiasUrl = `${api}noticia-app/${config$1.idUser}`;
  const dataPromoUrl = `${api}promocion-app/${config$1.idUser}`;
  const dataGetPromoUrl = `${api}promotional-contact`;
  async function initPlayer() {
    // await checkDomain()

    installPWA();
    initVolumeControl();
    setFakeEqualizer();
    const response = await fetch(mainFetchUrl);
    const data = await response.json();
    setApps(data);
    const isMultiradio = data.multiradio.length > 0;
    if (isMultiradio) {
      const response = await fetch(multiradioFetchUrl);
      const data = await response.json();
      const stations = data.map(station => normalizeData(station));
      loadStations = stations;
      setStationInfo(loadStations[0]);
      initAudio(loadStations[0].stream);
      setSocial(loadStations[0]);
    } else {
      const stationData = normalizeData(data);
      setStationInfo(stationData);
      initAudio(stationData.stream);
      setSocial(stationData);
      loadStations = [stationData];
    }
    async function init(station) {
      if (timeoutId) clearTimeout(timeoutId);
      const streamData = await getStreamData(station.stream);
      const query = createQuery(streamData);
      if (streamData.now_playing) {
        songProgress({
          duration: streamData.now_playing.duration,
          elapsed: streamData.now_playing.elapsed
        });
      }
      if (query !== currentQuery) {
        const searchData = await getDataFromSearchApi(query, config$1.service);
        const songData = setDefaultData({
          streamData,
          searchData,
          station
        });
        setCurrentSong(songData, station.cover);
        setMediaSession(songData, station.cover);
        setHistory(streamData.song_history, station);
        currentQuery = query;
      }
      timeoutId = setTimeout(() => {
        init(station);
      }, config$1.timeRefresh);
    }

    // Usar el nuevo módulo
    if (isMultiradio) {
      renderStationButtons({
        stations: loadStations,
        onStationChange: init
      });
    }
    await init(loadStations[0]);
  }
  async function initVideoApp() {
    const response = await fetch(dataVideoUrl);
    const data = await response.json();
    fetchVideoList(data);
  }
  async function initTeam() {
    const response = await fetch(dataTeamUrl);
    const data = await response.json();
    setTeamItems(data, config$1.baseUrl);
  }
  async function initProgram() {
    if (timeoutIdProgram) clearTimeout(timeoutIdProgram);
    const response = await fetch(dataProgramUrl);
    const data = await response.json();
    await setSchedule(data, config$1.baseUrl);

    // Refrescar cada 1 minuto
    timeoutIdProgram = setTimeout(() => {
      initProgram();
    }, 60000);
  }
  async function initSlide() {
    const response = await fetch(dataSlideUrl);
    const data = await response.json();
    setSlider(data, config$1.baseUrl);
  }
  async function initNoticias() {
    const response = await fetch(dataNoticiasUrl);
    const data = await response.json();
    setArticles(data, config$1.baseUrl);
  }
  async function initPromo() {
    const response = await fetch(dataPromoUrl);
    const data = await response.json();
    setPromos(data, config$1.baseUrl, dataGetPromoUrl);
  }
  initPlayer();
  initVideoApp();
  initProgram();
  initTeam();
  initSlide();
  initNoticias();
  initPromo();

})();
